unit EcoSpaceProvider;

interface

uses
  Borland.Eco.Handles,
  Borland.Eco.Web,
  SimpleEcoWebDemoEcoSpace;

		// ToDo: Configure the strategy for the provider by changing the constant
const
   MODE: EcoSpaceStrategyHandler.SessionStateMode = EcoSpaceStrategyHandler.SessionStateMode.IfDirty;
type
  TEcoSpaceProvider = class
  public
		class function GetEcoSpace: TSimpleEcoWebDemoEcoSpace; static;
    class procedure ReturnEcoSpace(aEcoSpace: EcoSpace); static;
		class function GetSessionFreeEcoSpace: TSimpleEcoWebDemoEcoSpace; static;
    class procedure ReturnSessionFreeEcoSpace(aEcoSpace: EcoSpace); static;
    class procedure ClearSessionState; static;
  end;

implementation

// Utility methods

function GetHandler :EcoSpaceStrategyHandler;
begin
  Result := EcoSpaceStrategyHandler.Create(MODE, typeof(TSimpleEcoWebDemoEcoSpace));
end;


{ TEcoSpaceProvider }

class procedure TEcoSpaceProvider.ClearSessionState;
begin
  GetHandler.ClearSessionState;
end;

class function TEcoSpaceProvider.GetEcoSpace(): TSimpleEcoWebDemoEcoSpace;
begin
  Result := TSimpleEcoWebDemoEcoSpace(GetHandler.GetEcoSpace);
end;

class procedure TEcoSpaceProvider.ReturnEcoSpace(aEcoSpace: EcoSpace);
begin
  GetHandler.ReturnEcoSpace(aEcoSpace);
end;

class function TEcoSpaceProvider.GetSessionFreeEcoSpace(): TSimpleEcoWebDemoEcoSpace;
begin
  Result := TSimpleEcoWebDemoEcoSpace(GetHandler.GetSessionFreeEcoSpace);
end;

class procedure TEcoSpaceProvider.ReturnSessionFreeEcoSpace(aEcoSpace: EcoSpace);
begin
  GetHandler.ReturnSessionFreeEcoSpace(aEcoSpace);
end;

end.
